using System;
using _Combo;
using _Core;

namespace Seayoo.ComboSDK.Windows
{
    public class ComboSDKError
    {
        public string Error { get; }
        public string Message { get; }
        public string DetailMessage { get; }

        private ComboSDKError(string error, string message, string detailMessage)
        {
            Error = error;
            Message = message;
            DetailMessage = detailMessage;
        }

        internal static ComboSDKError Create(InternalError e = null)
        {
            if (e == null)
            {
                return null;
            }
            return new ComboSDKError(ComboSDKErrorType.Convert(e.Cause), e.Message, e.DetailMessage);
        }
    }

    public static class ComboSDKErrorType
    {
        public static string InvalidArguments = "INVALID_ARGUMENTS";
        public static string UserCancelled = "USER_CANCELLED";
        public static string NetworkError = "NETWORK_ERROR";
        public static string ServerError = "SERVER_ERROR";
        public static string LoginError = "LOGIN_ERROR";
        public static string StoreError = "STORE_ERROR";
        public static string InitializedError = "INITIALIZED_ERROR";
        public static string UnknownError = "UNKNOWN_ERROR";
        public static string InvalidShortLink = "INVALID_SHORT_LINK";
        public static string InvalidGameData = "INVALID_GAME_DATA";
        public static string InvalidAnnouncementsUrl = "INVALID_ANNOUNCEMENTS_URL";
        public static string InvalidComplainUrl = "INVALID_COMPLAIN_URL";
        public static string InvalidGiftCodeUrl = "INVALID_GIFT_CODE_URL";
        public static string Convert(Exception cause)
        {
            switch (cause)
            {
                case InvalidArgumentsError _error:
                    if (_error.errorType == InvalidArgumentsErrorType.INVALID_SHORT_LINK)
                    {
                        return InvalidShortLink;
                    }
                    else if (_error.errorType == InvalidArgumentsErrorType.INVALID_GAME_DATA)
                    {
                        return InvalidGameData;
                    }
                    else if (_error.errorType == InvalidArgumentsErrorType.INVALID_ANNOUNCEMENTS_URL)
                    {
                        return InvalidAnnouncementsUrl;
                    }
                    else if (_error.errorType == InvalidArgumentsErrorType.INVALID_COMPLAIN_URL)
                    {
                        return InvalidComplainUrl;
                    }
                    else if (_error.errorType == InvalidArgumentsErrorType.INVALID_GIFT_CODE_URL)
                    {
                        return InvalidGiftCodeUrl;
                    }
                    return InvalidArguments;
                case LoginError _:
                    return LoginError;
                case NetworkError _:
                    return NetworkError;
                case ServerError _:
                    return ServerError;
                case StoreError _:
                    return StoreError;
                case InitializedError _:
                    return InitializedError;
                case UserCancelled _:
                    return UserCancelled;
                default:
                    return UnknownError;
            }
        }
    }
}
