
using System.Collections.Generic;

namespace Combo
{
    [System.Serializable]
    public class SetupOptions : Serializable
    {
        /// <summary>
        /// 由世游侧为游戏分配，用于标识游戏的业务代号，是一个字符串
        /// </summary>
        public string gameId;

        /// <summary>
        /// 由世游侧为游戏分配，Publishable keys 总是以 pk_ 为前缀
        /// </summary>
        public string publishableKey;

        /// <summary>
        /// Combo SDK Server Endpoint，目前区分国内 <see cref="Endpoint.CHINA"/> 与海外 <see cref="Endpoint.GLOBAL"/>
        /// </summary>
        public string endpoint; // HTTPS 端点

        [UnityEngine.HideInInspector]
        public Dictionary<string, object> extra = new Dictionary<string, object>();
    }

    public struct Endpoint
    {
        public static string CHINA = "https://api.seayoo.com";
        public static string GLOBAL = "https://api.seayoo.io";
    }
}

