using _Combo;
using _Combo.Events;
using _Core;
using UnityEngine;
using UnityEngine.UI;

namespace Seayoo.ComboSDK.Windows.Store.View
{
    public class PurchaseSuccessView : MonoBehaviour
    {
        public Button cancelBtn;
        public Text titleText;
        public Text paymentSuccessText;
        public Text tipText;
        public Text productNameTxt;
        public Text productValueTxt;
        public Image titleImage;
        public Sprite weixinSprite;
        public Sprite alipaySprite;
        public Sprite sandboxSprite;
        public RectTransform titleTransform;
        private Order order;
        void Awake()
        {
            EventSystem.Register(this);
            gameObject.SetActive(false);
        }

        void Start()
        {
            paymentSuccessText.text = I18n.T("payment_successful_title");
            tipText.text = I18n.T("payment_successful_text");
            cancelBtn.onClick.AddListener(OnClose);
        }

        void OnDestroy()
        {
            EventSystem.UnRegister(this);
            cancelBtn.onClick.RemoveListener(OnClose);
        }
        public void OnClose()
        {
            PurchaseSuccessEvent.Invoke(new PurchaseSuccessEvent{
                orderId = order.orderId
            });
            ClosePayViewCommand.Invoke();
        }

        [EventSystem.BindEvent]
        public void ShowPayView(GoToViewCommand action)
        {
            if (action.type != PayViewType.PAY_SUCCESS)
            {
                gameObject.SetActive(false);
                return;
            }
            gameObject.SetActive(true);
            productNameTxt.text = action.productName;
            productValueTxt.text = action.productValue;
            order = action.order;

            if (action.paymentMethod == PaymentMethods.WEIXIN_NATIVE)
            {
                titleText.text = I18n.T("weixin_pay_qrcode_text");
                titleImage.sprite = weixinSprite;
                titleImage.rectTransform.sizeDelta = new Vector2(36, 32);
                LayoutRebuilder.ForceRebuildLayoutImmediate(titleTransform);
            }
            else if (action.paymentMethod == PaymentMethods.ALIPAY_QR_CODE)
            {
                titleText.text = I18n.T("alipay_qrcode_text");
                titleImage.sprite = alipaySprite;
                titleImage.rectTransform.sizeDelta = new Vector2(30, 30);
                LayoutRebuilder.ForceRebuildLayoutImmediate(titleTransform);
            }
            else if (action.paymentMethod == PaymentMethods.SEAYOO_SANDBOX)
            {
                titleText.text = I18n.T("sandbox_payment_button");
                titleImage.sprite = sandboxSprite;
                titleImage.rectTransform.sizeDelta = new Vector2(36, 36);
                LayoutRebuilder.ForceRebuildLayoutImmediate(titleTransform);
            }
        }
    }
}