using Newtonsoft.Json;
using UnityEngine.Scripting;
using _Core;

namespace Seayoo.ComboSDK.Windows.Account.Model.Net
{
    [Preserve]
    public class LoginWithOTPRequest : Serializable
    {
        public string mobile;
        public string otp;
        public string action;
    }

    [Preserve]
    public class LoginWithOTPResponse : Serializable
    {
        public User user;
        [JsonProperty(PropertyName = "real_name_required")] public bool realNameRequired;
    }

    [Preserve]
    public class User : Serializable
    {
        [JsonProperty(PropertyName = "user_id")] public string userId;
        public string token;
        public string mobile;
        [JsonProperty(PropertyName = "real_name")] public string realName;
        [JsonProperty(PropertyName = "identity_card")] public string identityCard;
        [JsonProperty(PropertyName = "has_password")] public string hasPassword;
        public string status;
        [JsonProperty(PropertyName = "delete_after")] public string deleteAfter;
    }

}