﻿using System;
using System.Collections;
using System.Collections.Generic;
using _Combo;
using _Core;
using UnityEngine;
using UnityEngine.UI;

namespace _Combo
{
    [ViewPrefab("Prefabs/ComboWelcomeView")]
    internal class WelcomeView : View<WelcomeView>
    {
        public Text welcomeTxt;
        public Button switchBtn;
        public GameObject leftSubPanel;
        public GameObject rightSubPanel;
        public RectTransform toastTransform;
        public Image welcomeImage;
        public Image mobileImage;
        public Sprite backgroundTexture;
        public Sprite taptapTexture;
        public Sprite seayooTexture;
        public Sprite seayooIconTexture;

        private Vector3 startPosition;
        private Vector3 targetPosition;
        public float moveDuration = 0.3f;
        public float fadeDuration = 0.2f;

        private Action OnSwitchAccount;

        public void SetUserName(string text) {
            welcomeTxt.text = I18n.T("login_welcome_banner_text", new Dictionary<string, object>(){{"user", text}});
        }
        public void SetSwitchAccountCallback(Action callback) {
            OnSwitchAccount = callback;
        }

        public void SetImage(Credential credential)
        {
            if (credential is SeayooCredential)
            {
                welcomeImage.sprite = seayooTexture;
                mobileImage.sprite = seayooIconTexture;
            }
            else if (credential is TaptapCredential)
            {
                welcomeImage.sprite = backgroundTexture;
                mobileImage.sprite = taptapTexture;
            }
        }

        void Awake()
        {
            switchBtn.gameObject.GetComponent<Text>().text = I18n.T("switch_account_button");
        }

        void Start()
        {
            RectTransform canvasRect = GetComponentInParent<Canvas>().GetComponent<RectTransform>();
            startPosition = new Vector2(0, canvasRect.rect.height * 0.06f);
            targetPosition = new Vector2(0, -canvasRect.rect.height * 0.11f);
            toastTransform.anchoredPosition = startPosition;
            switchBtn.onClick.AddListener(OnClickSwitchAccount);
        }

        void OnDestroy() {
            switchBtn.onClick.RemoveListener(OnClickSwitchAccount);
        }

        void OnClickSwitchAccount() {
            OnSwitchAccount?.Invoke();
        }

        IEnumerator MoveToTarget()
        {
            float elapsedTime = 0.0f;

            while (elapsedTime < moveDuration)
            {
                float t = elapsedTime / moveDuration;
                toastTransform.anchoredPosition = Vector2.Lerp(startPosition, targetPosition, t);

                elapsedTime += Time.deltaTime;
                yield return null;
            }
        }

        IEnumerator FadeOut()
        {
            CanvasGroup canvasGroup = GetComponent<CanvasGroup>();
            float elapsedTime = 0.0f;
            float alpha = canvasGroup.alpha;
            while (elapsedTime < moveDuration)
            {
                float t = elapsedTime / moveDuration;
                canvasGroup.alpha = Mathf.Lerp(alpha, 0, t);

                elapsedTime += Time.deltaTime;
                yield return null;
            }
            canvasGroup.alpha = 0;
        }

        protected override IEnumerator OnHide()
        {
            yield return FadeOut();
        }

        protected override IEnumerator OnShow()
        {
            LayoutRebuilder.ForceRebuildLayoutImmediate(leftSubPanel.GetComponent<RectTransform>());
            LayoutRebuilder.ForceRebuildLayoutImmediate(rightSubPanel.GetComponent<RectTransform>());
            yield return MoveToTarget();
        }
    }
}
