using System;
using System.Collections.Generic;
using System.IO;
using Sentry;

namespace _Combo
{
    /// <summary>
    /// 面包屑数据
    /// </summary>
    public class EventBreadcrumb
    {
        /// <summary>
        /// Breadcrumb描述信息
        /// </summary>
        public string Message { get; set; }

        /// <summary>
        /// Breadcrumb类型
        ///
        /// A dotted string indicating what the crumb is or from where it comes.
        /// Typically it is a module name or a descriptive string
        /// </summary>
        public string Category { get; set; } = "combo";

        /// <summary>
        /// Breadcrumb危险等级
        /// </summary>
        
        public BreadcrumbLevel Level { get; set; } = BreadcrumbLevel.Info;

        /// <summary>
        /// Breadcrumb附加额外数据
        /// </summary>
        public Dictionary<string, string> Extra { get; set; }
    }

    /// <summary>
    /// 事件上下文数据
    /// </summary>
    public class EventScope
    {
        /// <summary>
        /// 事件上下文自定义数据
        /// </summary>
        public Dictionary<string, object> ContextMap { get; set; } = new Dictionary<string, object>();

        /// <summary>
        /// 事件标签数据
        /// </summary>
        public Dictionary<string, object> TagMap { get; set; } = new Dictionary<string, object>();

        /// <summary>
        /// 面包屑数据
        /// </summary>
        public List<EventBreadcrumb> Breadcrumbs { get; set; } = new List<EventBreadcrumb>();

        /// <summary>
        /// 待上传的附件文件
        /// </summary>
        public List<string> Attachments { get; set; } = new List<string>();

        /// <summary>
        /// Additional Data
        /// </summary>
        public Dictionary<string, string> Extra { get; set; } = new Dictionary<string, string>();

        /// <summary>
        /// 事件指纹
        /// </summary>
        public List<string> Fingerprint { get; set; } = new List<string>();

        /// <summary>
        /// 描述信息
        /// </summary>
        public string Description
        {
            get
            {
                return $@"EventData{{ context:{ContextMap} , tag:{TagMap} , breadcrumb:{Breadcrumbs} ,extra:{Extra} , attachment:{Attachments} }}";
            }
        }
    }
}