using System;
using System.Collections.Generic;
using _Core;

namespace _Combo
{
    public class InitializedError : BaseCause {
        public InitializedErrorType type;
        public Exception Cause { get; set; }
        public InitializedError(InitializedErrorType type, bool enableTracking = true, Exception cause = null)
        {
            this.type = type;
            EnableTracking = enableTracking;
            Cause = cause;
        }
        public override string GetMessage()
        {
            Dictionary<string, object> paramz = new Dictionary<string, object> {
                { "0", (int)type}
            };
            return I18n.T("sdk_init_error", paramz);
        }

        public override bool EnableTracking {
            get { return false;}
        }

        public override string ToString()
        {
            string result = $"InitializedError" +
                $"\ntype = {type}";
                
            if (Cause != null)
            {
                result += $"\ncause = {Cause}";
            }
            return result;
        }
    }

    public enum InitializedErrorType
    {
        CONFIGURATION_FILE_NOT_EXIST = 2001,
        LOAD_CONFIGURATION_FILE_ERROR = 2002,
        INIT_FAILED = 2003
    }
}