using _Combo;

public interface IStore : IFeature
{
    void Setup(StoreParameters storeParameters);
    void Purchase(string orderToken, Order order, PurchaseOptions purchaseOptions);
    string GetStore();
}

public class StoreParameters
{
    public string Endpoint { get; set; }
    public string GameId { get; set; }
    public string PublishableKey { get; set; }
    public string Distro { get; set; }
    public string UnitySdkVersion { get; set; }
    public string UnityVersion { get; set; }

    public StoreParameters(string endpoint, string gameId, string publishableKey, string distro, string unitySdkVersion, string unityVersion)
    {
        Endpoint = endpoint;
        GameId = gameId;
        PublishableKey = publishableKey;
        Distro = distro;
        UnitySdkVersion = unitySdkVersion;
        UnityVersion = unityVersion;
    }
}
