// {Leslie}

using System;

namespace Combo
{
    public class Error : Exception
    {
        /// <summary>
        /// Combo SDK 定义的业务错误码，例如：USER_CANCELLED
        /// </summary>
        public string Code { get; }

        /// <summary>
        /// 可阅读的提示信息，常用于弹窗显示，例如：用户取消
        /// </summary>
        override public string Message { get; }

        /// <summary>
        /// 错误详情，可用于日志输出，例如：errorMsg = 用户取消，cause = "UserCancelled()"。
        /// 注意：请勿在 UI 上显示
        /// </summary>
        public string DetailMessage { get; }

        public Error(string error, string message, string detailMessage)
        {
            Code = error;
            Message = message;
            DetailMessage = detailMessage;
        }

        public static Error CreateFromJson(string json)
        {
            var e = Serializable.FromJson<_Error>(json);
            return new Error(e.error, e.message, e.detailMessage);
        }
    }

    [System.Serializable]
    internal class _Error : Serializable
    {
        public string error;

        public string message;

        public string detailMessage;
    }
}
