using _Core;
using UnityEngine;
using UnityEngine.Scripting;
using _Combo;

namespace Seayoo.ComboSDK.Windows.TapTap
{
    [Preserve]
    public class TapTap : Singleton<TapTap>, IdP
    {
        public TapTap() { }

        public void Setup(SetupOptions opts)
        {
            Config.Init(opts.gameId);
            Init();
        }

        public void OnSignIn(bool isSuccess)
        {
            TapTapManager.GetInstance().SetAutoLoginEnabled(isSuccess);
        }

        public void Login()
        {
            TapTapManager.GetInstance().Login();
        }

        public void Logout()
        {
            TapTapManager.GetInstance().Logout();
            TapTapManager.GetInstance().SetAutoLoginEnabled(false);
        }

        public void LinkIdentity(Credential credential)
        {

        }

        private async void Init()
        {
            await TapTapManager.GetInstance().Init();
        }

        public bool IsFeatureAvailable(Feature feature)
        {
            switch (feature)
            {
                case Feature.CONTACT_SUPPORT:
                    return GlobalParameters.Instance.SeayooAccountSupportUrl != "";
                default:
                    return false;
            }
        }
    }
}
