using _Core;
using UnityEngine;
using UnityEngine.Scripting;
using _Combo;
using Seayoo.ComboSDK.Windows.Account.Net.v1;
using Seayoo.ComboSDK.Windows.Account.View;
using _Combo.Events;
using System;

namespace Seayoo.ComboSDK.Windows.Account
{
    // https://docs.unity3d.com/ScriptReference/Scripting.PreserveAttribute.html
    [Preserve]
    public class SeayooAccount : Singleton<SeayooAccount>, IdP
    {
        public SeayooAccount() { }

        private GameObject accountPrefab;

        public void Setup(SetupOptions opts)
        {
            try
            {
                Config.Init(opts.gameId);
                AccountClient.Setup(Config.endpoint, opts.unitySdkVersion, opts.unityVersion);
                SetupSuccessEvent.Invoke(new SetupSuccessEvent() { idp = "seayoo_account" });
            }
            catch (Exception error)
            {
                var setupError = new InitializedError(InitializedErrorType.INIT_FAILED, cause: error);
                SetupFailedEvent.Invoke(new SetupFailedEvent()
                {
                    
                    error = new InternalError(setupError)
                });
            }
        }

        public void Login()
        {
            Login(null);
        }

        public void Logout()
        {
            SeayooAccountManager.GetInstance().SetAutoLoginEnabled(false);
        }

        public void OnSignIn(bool isSuccess)
        {
            SeayooAccountManager.GetInstance().SetAutoLoginEnabled(isSuccess);
        }

        public void LinkIdentity(Credential credential)
        {
            View.GoToViewCommand.Invoke(new View.GoToViewCommand
            {
                viewType = SeayooAccountViewType.LINK,
                vo = credential
            });
        }

        private void Login(GameObject root = null)
        {
            if (accountPrefab == null)
            {
                accountPrefab = GameObject.Instantiate(Resources.Load("Prefabs/SeayooAccount")) as GameObject;
                if (root != null)
                {
                    Canvas canvas = root.GetComponent<Canvas>();
                    if (canvas != null)
                    {
                        Log.E("Do not attach account prefab to Canvas Component!!!");
                        return;
                    }
                    accountPrefab.transform.SetParent(root.transform, false);
                }
                Log.I("Add ComboSDK Account Prefabs");
            }
            else
            {
                Log.I("Prefab already exists, not creating a new one.");
            }
        }

        public bool IsFeatureAvailable(Feature feature)
        {
            switch (feature)
            {
                case Feature.SEAYOO_ACCOUNT:
                    return !GlobalParameters.Instance.SeayooAccountDisableSdkApi;
                case Feature.CONTACT_SUPPORT:
                    return GlobalParameters.Instance.SeayooAccountSupportUrl != "";
                default:
                    return false;
            }
        }
    }
}
