
using Newtonsoft.Json;
using UnityEngine.Scripting;
using _Core;

namespace Seayoo.ComboSDK.Windows.Account.Model.Net
{
    [Preserve]
    public class LoginWithPasswordRequest : Serializable
    {
        public string username;
        public string password;
        public bool encrypted;
        [JsonProperty(PropertyName = "captcha_id")]
        public string captchaId;
        [JsonProperty(PropertyName = "captcha_result")]
        public string captchaResult;
    }

    [Preserve]
    public class LoginWithPasswordResponse : Serializable
    {
        public User user;
        [JsonProperty(PropertyName = "device_grant_required")] public bool deviceGrantRequired;
        [JsonProperty(PropertyName = "device_grant_ticket")] public string deviceGrantTicket;
        [JsonProperty(PropertyName = "real_name_required")] public bool realNameRequired;
    }
}