// {Leslie}

using System;

namespace _Core
{
    [AttributeUsage(AttributeTargets.Class, Inherited = false, AllowMultiple = false)]
    sealed class IdPAttribute : Attribute
    {
        public string IdPName { get; }

        public IdPAttribute(string idpName)
        {
            IdPName = idpName;
        }
    }

    public static class AttributeUtils
    {
        public static string GetIdp(object obj)
        {
            var objType = obj.GetType();
            var attr = (IdPAttribute)Attribute.GetCustomAttribute(objType, typeof(IdPAttribute));
            if (attr == null) return null;

            return attr.IdPName;
        }
    }
}
