using System;
using System.Collections.Generic;

public class MethodQueue
{
    private readonly object _lock = new object();
    private readonly List<Action> _tasks = new List<Action>();

    public void Enqueue(Action task)
    {
        lock (_lock)
        {
            _tasks.Add(task);
        }
    }

    public void ExecuteAll()
    {
        List<Action> tasksToExecute;
        lock (_lock)
        {
            tasksToExecute = new List<Action>(_tasks);
            _tasks.Clear();
        }

        foreach (var task in tasksToExecute)
        {
            task();
        }
    }

    public void RemoveAll()
    {
        lock (_lock)
        {
            _tasks.Clear();
        }
    }
}