using System;
using System.Collections;
using System.Collections.Generic;
using _Combo;
using _Core;
using UnityEngine;
using UnityEngine.UI;

namespace _Combo
{
    [ViewPrefab("Prefabs/ComboAlertView")]
    internal class AlertView : View<AlertView>
    {
        public Text titleTxt;
        public Text contentTxt;
        public Button oneBtn;
        public Button twoRightBtn;
        public Button twoLeftBtn;
        public Text twoRightBtnTxt;
        public Text twoLeftBtnTxt;
        public Text oneBtnText;
        public RectTransform titlePanel;
        public RectTransform contentPanel;
        public RectTransform wholePanel;
        public Canvas canvas;
        private Action OnConfirm;
        private Action OnCancel;

        public void ShowTwoBtn()
        {
            twoLeftBtn.gameObject.SetActive(true);
            twoRightBtn.gameObject.SetActive(true);
            oneBtn.gameObject.SetActive(false);
        }
        public void ShowOneBtn()
        {
            twoLeftBtn.gameObject.SetActive(false);
            twoRightBtn.gameObject.SetActive(false);
            oneBtn.gameObject.SetActive(true);
        }
        public void SetTitle(string title) {
            titleTxt.text = title;
        }
        public void SetMessage(string content, TextAnchor textAnchor)
        {
            contentTxt.text = content;
            contentTxt.alignment = textAnchor;
        }
        public void SetRightBtnTitle(string title) {
            twoRightBtnTxt.text = title;
        }
        public void SetLeftBtnTitle(string title, int time = 0) {
            twoLeftBtnTxt.text = title;
            if(time <= 0) {
                return;
            }
            twoLeftBtnTxt.text = title + $"( {time}s )";
            StartCoroutine(StartCountdown(title, time));
        }

        public void SetOneBtnTitle(string title, int time = 0) {
            oneBtnText.text = title;
            if(time <= 0) {
                return;
            }
            oneBtnText.text = title + $"( {time}s )";
            StartCoroutine(StartCountdown(title, time));
        }
 
        IEnumerator StartCountdown(string title, int totalTime)
        {
            int remainingTime = totalTime;
            float startTime = Time.realtimeSinceStartup;
            float countdownDuration = remainingTime;

            while (remainingTime >= 0)
            {
                float elapsedTime = Time.realtimeSinceStartup - startTime;
                remainingTime = Mathf.CeilToInt(countdownDuration - elapsedTime);

                if (remainingTime < 0)
                {
                    OnCancel.Invoke();
                    yield return null;
                }
                else
                {
                    oneBtnText.text = title + $"( {remainingTime}s )";
                    yield return new WaitForSecondsRealtime(1f);
                }
            }
        }

        public void SetConfirmCallback(Action OnConfirm) {
            this.OnConfirm = OnConfirm;
        }
        public void SetCancelCallback(Action OnCancel) {
            this.OnCancel = OnCancel;
        }

        public void SetSortOrder(int sortOrder)
        {
            canvas.sortingOrder = sortOrder;
        }

        void Awake()
        {
            twoRightBtn.onClick.AddListener(OnClickConfirmBtn);
            twoLeftBtn.onClick.AddListener(OnClickCancelBtn);
            oneBtn.onClick.AddListener(OnClickCancelBtn);
            
        }
        void OnDestroy()
        {
            twoRightBtn.onClick.RemoveListener(OnClickConfirmBtn);
            twoLeftBtn.onClick.RemoveListener(OnClickCancelBtn);
            oneBtn.onClick.RemoveListener(OnClickCancelBtn);
        }
        void OnClickConfirmBtn() {
            OnConfirm.Invoke();
        }
        void OnClickCancelBtn() {
            OnCancel.Invoke();
        }
        protected override IEnumerator OnHide()
        {
            yield return null;
        }

        protected override IEnumerator OnShow()
        {
            LayoutRebuilder.ForceRebuildLayoutImmediate(titlePanel);
            LayoutRebuilder.ForceRebuildLayoutImmediate(contentPanel);
            LayoutRebuilder.ForceRebuildLayoutImmediate(wholePanel);
            yield return null;
        }
    }
}
