using System;
using _Core;

namespace _Combo
{
    public class ServerError : BaseCause
    {
        public string Url { get; set; } = "";
        public int StatusCode { get; set; }
        public string Error { get; set; } = "";
        public string ErrorMsg { get; set; } = "";
        public string TraceId { get; set; } = "";
        public Exception Cause { get; set; }

        public ServerError(int statusCode, string url = "", string error = "", string errorMsg = "", string traceId = "", Exception cause = null)
        {
            StatusCode = statusCode;
            Url = url;
            Error = error;
            ErrorMsg = errorMsg;
            TraceId = traceId;
            Cause = cause; 
        }

        public override bool EnableTracking {
            get { return !(StatusCode >= 400 && StatusCode < 500); }
        }

        public override string GetMessage()
        {
            if (ErrorMsg != "")
            {
                return ErrorMsg;
            }
            else
            {
                return I18n.T("server_error");
            }
        }

        public override string ToString()
        {
            string result = $"ServerError" +
                $"\nurl = {Url}" +
                $"\nstatusCode = '{StatusCode}'";

            if (!string.IsNullOrEmpty(Error))
            {
                result += $"\nerror = '{Error}'";
            }
            if (!string.IsNullOrEmpty(ErrorMsg))
            {
                result += $"\nerrorMsg = '{ErrorMsg}'";
            }
            if (!string.IsNullOrEmpty(TraceId))
            {
                result += $"\ntraceId = '{TraceId}'";
            }
            if (Cause != null)
            {
                result += $"\ncause = {Cause}";
            }

            return result;
        }
    }
}