using _Core;
namespace _Combo
{
    public class ComboResult {
        private Result<object, InternalError> result;
        public static ComboResult CreateSuccess()
        {
            return new ComboResult
            {
                result = Result<object, InternalError>.CreateSuccess(null)
            };
        }
        public static ComboResult CreateFail(InternalError value)
        {
            return new ComboResult
            {
                result = Result<object, InternalError>.CreateFail(value)
            };
        }
        public InternalError Error => result.Error;
        public bool IsSuccess => result.IsSuccess;
    }
    
    public class ComboResult<T>
    {
        private Result<T, InternalError> result;
        public static ComboResult<T> CreateSuccess(T value)
        {
            return new ComboResult<T>
            {
                result = Result<T, InternalError>.CreateSuccess(value)
            };
        }
        public static ComboResult<T> CreateFail(InternalError value)
        {
            return new ComboResult<T>
            {
                result = Result<T, InternalError>.CreateFail(value)
            };
        }

        public T Data => result.Data;

        public InternalError Error => result.Error;

        public bool IsSuccess => result.IsSuccess;
    }
}
