package com.seayoo.sdk;

import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.MotionEvent;

import com.seayoo.sdk.api.ComboSDK;
import com.unity3d.player.UnityPlayerActivity;

public class ComboSDKMainActivity extends UnityPlayerActivity {

    public boolean isKeepRenderingOnPause = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ComboSDK.getInstance().onCreate(this, savedInstanceState);
    }

    @Override
    protected void onNewIntent(Intent intent)
    {
        super.onNewIntent(intent);
        ComboSDK.getInstance().onNewIntent(this, intent);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        ComboSDK.getInstance().onSaveInstanceState(this, outState);
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        ComboSDK.getInstance().onRestoreInstanceState(this, savedInstanceState);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ComboSDK.getInstance().onActivityResult(this, requestCode, resultCode, data);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        ComboSDK.getInstance().onRequestPermissionsResult(this, requestCode, permissions, grantResults);
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        ComboSDK.getInstance().onBackPressed(this);
    }

    @Override
    protected void onDestroy ()
    {
        super.onDestroy();
        isKeepRenderingOnPause = false;
        ComboSDK.getInstance().onDestroy(this);
    }

    @Override
    protected void onStart()
    {
        super.onStart();
        ComboSDK.getInstance().onStart(this);
    }

    @Override
    protected void onPause()
    {
        super.onPause();
        keepRenderingOnPause();
        ComboSDK.getInstance().onPause(this);
    }

    @Override
    protected void onResume()
    {
        super.onResume();
        ComboSDK.getInstance().onResume(this);
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        ComboSDK.getInstance().onRestart(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        mUnityPlayer.pause();
        ComboSDK.getInstance().onStop(this);
    }

    @Override
    public void onLowMemory()
    {
        super.onLowMemory();
    }

    @Override
    public void onTrimMemory(int level)
    {
        super.onTrimMemory(level);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        ComboSDK.getInstance().onConfigurationChanged(this, newConfig);
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus)
    {
        super.onWindowFocusChanged(hasFocus);
        ComboSDK.getInstance().onWindowFocusChanged(this, hasFocus);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event)
    {
        return super.dispatchKeyEvent(event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event)
    {
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) 
    {
        ComboSDK.getInstance().onKeyDown(this, keyCode, event); 
        return super.onKeyDown(keyCode, event); 
    }

    @Override
    public boolean onTouchEvent(MotionEvent event)
    {
        return super.onTouchEvent(event);
    }

    private void keepRenderingOnPause() {
        if (!isKeepRenderingOnPause) return;
        mUnityPlayer.resume();
        mUnityPlayer.postInvalidate();
        onWindowFocusChanged(true);
        isKeepRenderingOnPause = false;
    }

}
