## 2.10.0 (2025-10-30)

**BUG FIXES:**

- Windows：修复 `AlertView ` 打开时闪烁问题

## 2.9.0 (2025-10-16)

**FEATURES:**

- `ComplainOptions` 新增 `Context` 字段

**BUG FIXES:**

- WebGL: 修复处理字符串时内存分配报错的问题

## 2.8.0 (2025-09-26)

**FEATURES:**

- Android: 支持团结引擎
- Windows: 新增支付流程 v2，全新的 UI 适配和交互流程
- iOS: 抖音游戏添加 `NSUserTrackingUsageDescription`

**IMPROVEMENTS:**

- Windows: 优化世游通行证，使其首次打开不再闪烁

**BUG FIXES:**

- Windows: 修复激活码空引用异常的问题
- Windows: 修复不包含 taptap domain 时，包体依旧含有 taptap dll 的问题

## 2.7.1 (2025-09-22)

**IMPROVEMENTS:**

- Windows: 删除 OnKickOut 在初始化时的限制，不再受初始化时机的影响

## 2.7.0 (2025-09-18)

**FEATURES:**

- Sentry: 升级至 3.2.3

**IMPROVEMENTS:**

- Windows: 世游通行证 UI 优化
- Combo: 优化初始化失败时 Sentry 上报的错误信息

## 2.6.0 (2025-09-04)

**IMPROVEMENTS:**

- WebGL: 优化桥接层代码

## 2.5.4 (2025-09-02)

**BUG FIXES:**

- Windows: 修复公告内部红点显示不正确的问题 

## 2.5.3 (2025-08-28)

**IMPROVEMENTS:**

- Windows: 优化 WebView 缓存路径设置，避免多次设置导致报错 

## 2.5.2 (2025-08-28)

**BUG FIXES:**

- Windows: 修复 TapTap 切换账号后无法登录的问题
- Windows: 修复 Webview 在竖屏显示中字体过于小的问题 

## 2.5.1 (2025-08-25)

**BUG FIXES:**

- OpenHarmony: 修复 OnKickOut 无法触发的问题
- Windows: 修复 GetParameters 在无网络状态下，错误提示有误的情况

## 2.5.0 (2025-08-21)

**FEATURES:**

- Windows: TapTap 支持 PC 端登录
- OpenHarmony: 新增 `OnDeepLinkActivated` API，以接收 HarmonyOS 平台深度链接回调
- Sentry: Unity Sentry 上报支持 OpenHarmony 平台

## 2.4.0 (2025-08-14)

**FEATURES:**

- 支持在团结引擎中导出 Windows、WebGL、iOS 、OpenHarmony 平台项目
- Windows: 新增登录流程 v2，全新的 UI 适配和交互流程
- thinking: 升级至 3.4.0-beta.1

## 2.3.0 (2025-06-26)

**FEATURES:**

- WebGL: 支持支付功能

**IMPROVEMENTS:**

- combo: Native 添加 Editor 模式下的代码逻辑

## 2.0.1 (2025-06-13)

**IMPROVEMENTS:**

- Windows: 优化手机号登录时获取验证码的表现效果

**BUG FIXES:**

- Windows: 修复 WebView url 错误问题

## 2.1.0 (2025-05-28)

**FEATURES:**

- Sentry:  支持 WebGL 平台的 dsn 参数传入

## 2.0.0 (2025-05-15)

**FEATURES:**

- WebGL: 支持导出 WebGL 平台项目
- Windows: 新增限号测试功能

**IMPROVEMENTS:**

- Windows: 初始化时清除 Vuplex 缓存

**BUG FIXES:**

- Windows: 修复 Vuplex 插件崩溃导致 SDK 初始化失败问题

## 1.24.1 (2025-04-24)

**FEATURES:**

- Android: 构建时添加对 Unity 2021 版本的支持

## 1.24.0 (2025-04-17)

**IMPROVEMENTS:**

- Combo SDK 上报的 Sentry 事件添加 Tag，便于区分事件来源

## 1.23.0 (2025-04-03)

**IMPROVEMENTS:**

- TapTap SDK 升级至 v4.5.4
- Windows: 短链接新增 `id_token_not_required` 参数

## 1.22.0 (2025-03-20)

**REFACTOR:**

- 重构 WebView 组件

**IMPROVEMENTS:**

- Windows: 本地服务动态分配端口，避免端口冲突问题
- Windows: 短链接机制改造，以适配微信小程序的无感跳转
- Windows: 游戏公告页面增加透明背景，以支持异形边框的公告
- Windows: 优化短链接、礼包码、举报界面弱网时，点击后 loading 界面无法及时显示，导致用户体验感较差的问题
- iOS: 适配 Xcode 16

**BUG FIXES:**

- WebView 添加 UA

## 1.20.6 (2025-03-07)

**IMPROVEMENTS:**

- Windows: 优化短链接、礼包码、举报界面，点击后 loading 界面无法及时显示，导致用户体验感较差的问题

## 1.20.5 (2025-03-06)

**IMPROVEMENTS:**

- Windows: 优化短链接闪白问题

**BUG FIXES:**

- Windows: 更换 Vuplex 插件程序集名称，并且为每个游戏实例设置不同的 Chromium 缓存路径，以修复多个游戏实例无法同时运行 Webview 的问题

## 1.20.4 (2025-03-04)

**BUG FIXES:**

- iOS: 通过 PostBuild 脚本在 [`Info.plist`](https://developer.apple.com/documentation/bundleresources/information-property-list?language=objc) 文件中配置以下键，修复在联系客服时进行拍照或录像应用崩溃问题
  - [NSCameraUsageDescription](https://developer.apple.com/documentation/bundleresources/information-property-list/nscamerausagedescription?language=objc)
  - [NSMicrophoneUsageDescription](https://developer.apple.com/documentation/bundleresources/information-property-list/nsmicrophoneusagedescription?language=objc)

## 1.20.3 (2025-03-03)

**BUG FIXES:**

- iOS: `LSApplicationQueriesSchemes` 中声明 `weixin`，修复未接入微信领域时无法跳转微信问题

## 1.21.0 (2025-02-28)

**IMPROVEMENTS:**

- Windows: 优化构建时获取文件路径的方式，改为使用包管理器的方式获取

## 1.20.2 (2025-02-27)

**BUG FIXES:**

- Windows: 修复联想渠道登录窗口关闭后无法再次打开的问题
- Windows: 修复在特定分辨率下世游通行证欢迎界面显示不全的问题

## 1.20.1 (2025-02-25)

**FEATURES:**

- Windows: 支持 自定义配置 `ComboSDK.json` 文件路径

**BUG FIXES:**

- Windows: 游戏使用 NGUI 时在所有程序集查找 `UICamera`，解决在 SDK 界面显示过程中依然能够点击游戏 UI 问题
- Windows: 修复游戏使用 NGUI 时，支付界面无法点击问题

## 1.20.0 (2025-02-20)

**FEATURES:**

- Windows: 集成 联想端游联运 SDK，支持联想 PC 联运发行版本
- Windows: 世游通行证增加人机验证安全防护机制

**IMPROVEMENTS:**

- Windows: 改进打开短链接机制，以支持直接跳转至微信小程序
- Windows: 优化 HttpServer

## 1.19.1 (2025-02-18)

**BUG FIXES:**

- Windows: 修复构建期间重命名文件夹时 .meta 文件未删除使其 unity 自动重新创建该目录导致构建失败的 Bug

## 1.19.0 (2025-02-13)

**FEATURES:**
- `ShareTarget` 增加 `QQ` ，以支持分享至 QQ 平台
- `ShareScene` 增加 `QQ`、`QZONE`，以支持分享至 QQ 好友与 QQ 空间

**IMPROVEMENTS:**
- Windows: 根据 `ComboSDK.json` 文件自动化装配第三方渠道库，以减少游戏包体的无关组件

## 1.18.0 (2025-01-16)

**FEATURES:**

- Windows: 新增礼包码直接兑换的方式

**IMPROVEMENTS:**

- iOS: 根据领域参数装配产物，产物缺失时中止 Build 流程
- Windows: 适配竖屏 UI
- Windows: 补充对外注释
- Windows: 支付失败时将 Order 信息上传到 Sentry Context
- Windows: 新增未登录时举报和礼包码功能不可用的错误处理
- Windows: 新增登录和支付时没有相应 distro 的错误处理

**BUG FIXES:**

- Windows: 修复使用 NGUI 时 UICamera 未完成初始化导致鼠标穿透的问题
- Windows: 修复当自动登录无网络时 ErrorResponse Json 格式转换失败导致报错的问题

## 1.15.0 (2024-12-19)

**FEATURES:**

- Windows: 支持通过系统浏览器打开短链接，并支持打开微信小程序指定页面
- Windows: 新增 API `RedeemGiftCode`，支持礼包码功能

**IMPROVEMENTS:**

- Windows: 世游通行证未成年用户可登录时间登录游戏成功后增加防沉迷提示弹窗
- iOS: PostBuild 使用一个目录装配参数文件及 iOS SDK 产物

**BUG FIXES:**

- Windows: 修复防沉迷踢出账号提示弹窗弹出时机不合理问题

## 1.14.9 (2024-12-09)

**IMPROVEMENTS:**

- iOS: PostBuild 支持装配百度联盟广告源资源文件

## 1.14.6 (2024-12-04)

**IMPROVEMENTS:**

- Windows: 世游游戏商城支持选择商品数量

## 1.14.5 (2024-11-28)

**FEATURES:**

- Windows: 新增本地服务，支持 WebView 网页从本地服务中加载静态资源

**IMPROVEMENTS:**
- Windows: 完善错误提示信息，进一步细分常见错误类型，以便排查、定位问题
- Windows: 删除世游通行证账号记录时增加二次确认弹窗

## 1.14.0 (2024-11-19)

**FEATURES:**

- Windows: 支持沙盒支付

## 1.13.0 (2024-11-13)

**FEATURES:**

- 新增 API `LanguagePreference`，用于设置或获取 SDK 当前使用的语言偏好
- 新增 API `LanguageCode`，用于获取 SDK 当前使用的语言代码
- 新增 API `ResetGuest`，用于抹除当前设备存储的游客账号数据
- Windows: 支持多语言

## 1.12.0 (2024-10-30)

**IMPROVEMENTS:**

- Windows: 优化世游通行证 token 界面删除账号的提示文案

## 1.11.0 (2024-10-17)

**FEATURES:**

- 新增 `Complain` 接口，支持游戏内举报功能
- Sentry: 支持配置 [启用截屏](https://docs.sentry.io/platforms/unity/enriching-events/screenshots/)

**IMPROVEMENTS:**

- Windows: 优化世游通行证 UI 表现
- Windows: 优化世游通行证网络请求错误处理，不再使用 StatusCode 进行业务错误判断

## 1.10.0 (2024-09-29)

**FEATURES:**

- Windows：新增 GetDownloadUrl 接口
- Windows：新增 OnKickOut 接口，支持防沉迷

**IMPROVEMENTS:**

- Sentry: 集成 `maxBreadcrumbs`、`addBreadcrumbsForLogTypes` 和 `captureLoggingErrorEnabled ` 三个参数
- Windows：优化内置 Loading 弹窗体验

**BUG FIXES:**

- Windows: 修复验证码登录页面倒计时显示异常问题

## 1.9.0 (2024-09-12)

**FEATURES:**

- `PreloadAdOptions` 和 `ShowAdOptions` 新增 `scenarioId` 参数

**IMPROVEMENTS:**

- Windows：TapTap 登录新增年龄限制
- Windows: WebView 新增跳转浏览器和查询客户端支持的所有 cmd 命令的功能
- Windows：优化 Setup 流程
- Windows：优化世游通行证 UI，字体大小调整
- Windows：优化 Toast 弹窗显示，使 Toast 仅在流程中弹窗
- windows: 优化 sentry 上报内容

**BUG FIXES:**

- Windows: 修复短链接没有错误回调的问题
- Windows: 修复公告成功回调时机不正确的问题
- Windows: 修复支付失败未回调相关问题
- Windows: 修复支付时没有配置支付方式依旧会执行该支付方式的流程问题

## 1.8.1 (2024-08-30)

**BUG FIXES:**

- Windows: 将 WebView 中预制体的引用改成运行时动态生成，解决竖屏无法显示的问题

## 1.8.0 (2024-08-27)

**FEATURES:**

- 支持 `Unity 2022.3.x`

**BREAKING CHANGES:**

- Share API 中的 `Contents` 属性已移除，请使用 `Text`

**IMPROVEMENTS:**

- Windows：优化错误处理

## 1.7.0 (2024-08-14)

**FEATURES:**

- Android：新增 `PromoPseudoPurchase` 接口，用于伪付费上报

**DEPRECATED:**

- Share API 中的 `Contents` 替换成 `Text`，并且 `Contents` 在 v1.8.0 版本中移除，请使用新字段 `Text`

**IMPROVEMENTS:**

- Windows：WebView 的拖动方式由 Drag To Scroll 改为 Drag Within Page
- Windows：优化 game-api Header

**BUG FIXES:**

- Windows: 修复打开 WebView 后无法自动切换为英文输入法的问题
- Windows：修复后台无配置时 bool 类型的值返回值为空字符串导致参数解析失败的问题

## 1.6.4 (2024-07-31)

**FEATURES:**

- Windows: 新增匿名功能

## 1.6.3 (2024-07-29)

**BUG FIXES:**

- Windows: 修复 WebRequest 过程中内存泄露的问题

**IMPROVEMENTS:**

- Windows: 弱网情况下获取验证码新增 Loading UI
- Windows：优化 WebView UI

## 1.6.2 (2024-07-25)

**BUG FIXES:**

- Windows: 修复超链接顶点解析错误的问题

**IMPROVEMENTS:**

- Windows: 更换字体
- Windows：实名认证 UI 上新增清除按钮

## 1.6.1 (2024-07-23)

**BUG FIXES:**

- Windows: 修复无法打开游戏公告中链接问题

## 1.6.0 (2024-07-16)

**FEATURES:**

- Windows: 新增 TapTap 登录
- Windows：新增账号关联，TapTap 可强制关联至世游通行证

## 1.5.2 (2024-07-16)

**IMPROVEMENTS:**

- iOS: PostBuild 支持装配 ComboSDKBDASignal 组件

## 1.5.1 (2024-07-10)

**BUG FIXES:**

- Windows: 修复在使用 NGUI 时无法响应输入事件的问题

## 1.5.0 (2024-07-04)

**FEATURES:**

- 新增 `LinkShareOptions`
- Windows: 新增 `CheckAnnouncements` 和 `OpenAnnouncements` 接口，用于打开游戏公告

## 1.4.0 (2024-06-27)

**FEATURES:**

- Windows: 新增 `ContactSupport`接口，WebView 打开联系客服页面
- Windows: 新增世游通行证账号功能
- Windows: 新增 `OpenGameUrl`接口，WebView 展现特定功能的 Web 页面
- Windows: 新增 `OpenShortLink`接口， WebView 打开 Gamer 短链接
- Windows: 新增 `IsFeatureAvailable(feature: ComboSDKFeature)`，检查特定的功能（Feature）是否可用

## 1.3.2 (2024-06-17)

**IMPROVEMENTS:**

- Android: 新增 `Enable Keep Rendering on Pause`，勾选时，弹出 Combo SDK 界面 Unity 将不再停止渲染

## 1.3.1 (2024-06-14)

**IMPROVEMENTS:**

- iOS: 当集成 `ComboSDKAgora` 或 `ComboSDKDouyinOpen` 组件时，通过 PostBuild 为 Xcode 工程添加访问相册权限
  
## 1.3.0 (2024-06-14)

**FEATURES:**

- 新增 `ImageShareOptions` 和 `VideoShareOptions`

## 1.2.0 (2024-06-06)

**FEATURES:**

- 新增 `OpenShortLink()` 方法，用于 WebView 打开 Gamer 短链接

**IMPROVEMENTS:**

- HTTP header `x-sdk-version` 增加 Unity SDK 和 Unity 的版本号信息
  
**BUG FIXES:**

- 修复数数 variant 为空使用缓存数据的问题

## 1.1.0 (2024-05-30)

**FEATURES:**

- iOS: 接入[巨量引擎转化归因 SDK](https://bytedance.larkoffice.com/docx/ZanOdTN6EobL07xbQZccyI3Fn5c)

## 1.0.0 (2024-05-23)

**FEATURES:**

- iOS: 接入 `didRegisterForRemoteNotificationsWithDeviceToken`

## 0.9.1 (2024-05-16)

**BUG FIXES:**

- iOS: 修复调用 `GetDownloadUrl()` 方法无回调问题

## 0.9.0 (2024-05-10)

**FEATURES:**
- Windows: 新增世游游戏商城
  
## 0.8.0 (2024-04-29)

**FEATURES:**
- 新增 `OpenGameUrl()` 方法，用于 WebView 展现特定功能的 Web 页面
- Windows: 新增密码登录和新设备验证
- Windows: 支持隐藏欢迎进入/切换账号 UI
- thinking_data: 新增 iOS `PrivacyInfo.xcprivacy` 隐私清单文件

**BUG FIXES:**
- Android: 修复 KickOut 无法调用的问题

## 0.6.4 (2024-04-23)

**IMPROVEMENTS:**
- thinking_data: 支持设置 native super properties

## 0.6.3 (2024-04-19)

**BUG FIXES:**
- iOS: 修复 `PrePostBuild` 时没有勾选 `EnableIOSPostBuild` 仍旧会执行的问题

**IMPROVEMENTS:**
- Windows: 增加 `Configuration` 错误追踪

## 0.6.2 (2024-04-15)
  
**IMPROVEMENTS:**
- iOS: 当集成 `ComboSDKTopOn` 或 `ComboSDKTrackingIO` 组件时，iOS PostBuild 在 `Info.plist` 文件中添加跟踪权限请求描述文字 —— `NSUserTrackingUsageDescription`
- iOS: iOS PostBuild 中自动检查匹配 `XCFrameworks` 组件

## 0.6.1 (2024-04-12)

**BUG FIXES:**
- iOS: 修复 IOS PostBuild 没有配置 Framework Search Paths
  
**IMPROVEMENTS:**
- iOS：优化 IOS PostBuild 配置 `XCFrameworks` 与 `ComboSDK.json` 绝对路径改为相对路径

## 0.6.0 (2024-04-11)

**FEATURES:**
- iOS: 支持自动装配 `XCFrameworks` 与 `ComboSDK.json`

## 0.5.5 (2024-04-03)

**FEATURES:**

- 新增 `SeayooAccount` 类，聚合通行证相关功能，目前包括：
  - 获取世游通行证 ID  `UserId`
  - 管理账号  `ManageAccount()`
  - 删除账号  `DeleteAccount()`
  - 修改密码  `ChangePassword()`
- 新增 `ContactSupport()` 方法，用于使用联系客服功能

**IMPROVEMENTS:**

- 优化 Sentry 上报，添加以下 Tag 
  - `combo.sdk.version`
  - `combo.distro`
  - `combo.device_id`
  - `combo.subvariant`
  - `combo.variant`

## 0.5.0 (2024-03-28)

**DEPRECATED:**

- 移除 `SocialShare()`，请使用 `Share()`

**FEATURES:**

- **用户隐私保护指引** 支持 iOS 平台

**IMPROVEMENTS:**

- Sentry: [关闭对 ANR 事件的捕获和报告](https://docs.sentry.io/platforms/unity/configuration/app-not-responding/)

## 0.4.1 (2024-03-20)

**DEPRECATED:**

- `SocialShare()` 将在 v0.5.0 版本中移除，请使用 `Social()`

**FEATURE:**

- 新增以下接口
  - `OpenAppSettings()`
  - `GetAvailableShareTargets()`
- `Feature` 枚举新增`PRODUCT_QUANTITY`成员，用于判断安卓渠道商店是否支持选择商品数量
- 新增 `TapTapShareOptions`

**IMPROVEMENTS:**
- `Plugins/Android` 增加 `ComboSDKApplication.java`

## 0.4.0 (2024-03-14)

**BUG FIXES:**

- Windows: 修复登录失败后依然可能执行快速登录问题

## 0.3.0 (2024-02-28)

**FEATURES:**

- 新增以下接口
  - `ReportCreateRole()`
  - `ReportEnterGame()`
  - `GetVariant()`
  - `GetSubVariant()`
  - `GetDownloadUrl()`

**IMPROVEMENTS:**

- 优化 ComboSDK.Setup 调用时机
- Windows: 弹出 SDK 界面自动屏蔽 NGUI 输入事件，解决点击穿透问题

## 0.2.1 (2024-02-19)

**BUG FIXES:**

- iOS: 修复 `Unity 2021.3 or later` 版本中初始化失败问题

## 0.2.0 (2024-02-02)

**BREAKING CHANGES:**

- `Setup` 不需要主动调用，改为由 Combo SDK 自行初始化。
- Windows：不再支持 **32-bit** 操作系统

**BUG FIXES:**

- Windows: 修复快速登录失败时无响应问题

**FEATURES:**

- 接入 `Sentry`
- 新增以下接口
  - `SocialShare()`
  - `OnKickOut()`
  - `IsFeatureAvailable()`
  - `UpdateGame()`
  - `GetDeviceId()`

- Windows: 欢迎页面新增 **切换账号** 入口
- Windows: 新增防沉迷限制与封禁账号登录时的提示弹窗

## 0.1.4 (2024-01-19)

**IMPROVEMENTS**

- Windows: 优化欢迎页面实现方式

**FEATURES**

- Windows: 适配 `ThinkingDataSDK`

## 0.1.3 (2024-01-16)

**BREAKING CHANGE**

- Android: 使用 `PostProcessBuild` 替换 `Unity PLugin Templates`

## 0.1.2 (2024-01-15)

**BREAKING CHANGE**

- 最低支持 `Unity 2019.4 or later`

**FEATURES**

- 集成 [`ThinkingDataSDK v3.0.1`](https://docs.thinkingdata.cn/ta-manual/latest/installation/installation_menu/client_sdk/game_engine_sdk_installation/unity_sdk_installation/unity_sdk_installation.html) 
- [TopOn](https://docs.thinkingdata.jp/ta-manual/latest/user_guide/data/thirdparty/thirdparty_topon.html#_1-2-%E6%96%B9%E6%A1%88%E4%BA%8C-%E6%89%8B%E5%8A%A8%E9%9B%86%E6%88%90) 支持自动关联 ThinkingData


## 0.1.1 (2024-01-05)

**FEATURES**

新增以下接口
- `GetVersion()`
- `GetVersionNative()`
- `GetDistro()`

**BREAKING CHANGE**

- API Model 删除 `ComboSDK` 前缀

## 0.1.0 (2023-12-30)

**FEATURES**

- Combo SDK for Unity `0.1.0` 功能首次提交
