//
//  DouyinOC.h
//  ComboSDKDouyin
//
//  Created by Zhang Gang on 2024/12/4.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@interface DouyinOC : NSObject

+ (void)setupWithConfigFilePath:(NSString *)configFilePath
                     completion:(void(^)(NSError * _Nullable err))completion;

/*! @abstract 游戏激活
 */
+ (Boolean)trackGameActive;

/*! @abstract 账号注册
 @param userID 用户唯一标识
 */
+ (Boolean)trackAccountRegisterWithUserID:(NSString *) userID;

/*! @abstract 账号注册
 @param userID 用户唯一标识
 */
+ (Boolean)trackAccountLoginWithUserID:(NSString *) userID;

@end

NS_ASSUME_NONNULL_END
