//
//  DouyinUGOC.h
//  ComboSDKDouyinUG
//
//  Created by 程小康 on 2025/12/11.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface DouyinUGOC : NSObject

/*! @abstract 游戏激活
 */
+ (BOOL)trackGameActive;

/*! @abstract 账号注册
 @param userID 用户唯一标识
 */
+ (BOOL)trackAccountRegisterWithUserID:(NSString *) userID;

/*! @abstract 账号注册
 @param userID 用户唯一标识
 */
+ (BOOL)trackAccountLoginWithUserID:(NSString *) userID lastLoginTime:(int64_t)lastLoginTime;
/**
 用户付费事件上报
 @param gameUserID 游戏内账号唯一ID  必填
 @param gameRoleID 游戏内角色唯一ID，若不回传则请填空串""  非必填
 @param gameOrderID 订单唯一标记 必填
 @param totalAmount 订单支付金额，单位为分，需要 > 0 必填
 @param productID 商品ID，若不回传则请填空串"" 非必填
 @param productName 商品名称，若不回传则请填空串"" 非必填
 @param productDesc 商品描述，若不回传则请填空串"" 非必填
 */
+ (BOOL)trackPurchase:(NSString *)gameUserID
   gameRoleID:(NSString * _Nullable)gameRoleID
  gameOrderID:(NSString *)gameOrderID
  totalAmount:(int64_t)totalAmount
  productID:(NSString * _Nullable)productID
  productName:(NSString * _Nullable)productName
  productDesc:(NSString * _Nullable)productDesc;


@end

NS_ASSUME_NONNULL_END
