//
//  UOPManager.h
//  UnionOpenPlatform
//
//  Created by ByteDance on 2021/6/21.
//

#import <Foundation/Foundation.h>
#import <UnionOpenPlatformCore/UOPConfigManager.h>

NS_ASSUME_NONNULL_BEGIN

@interface UOPManager : NSObject

+ (instancetype)sharedManager;

/// 接收并处理 scheme
/// @param url 系统方法参数透传，需要处理的 scheme
/// @param options 系统方法参数透传
/// @return 是否能接受传入的 URL
- (BOOL)handleOpenURL:(NSURL *)url options:(NSDictionary * _Nullable)options;

/// SDK初始化接口
/// @param configFilePath 配置文件沙盒路径
/// @discussion 读取传入的UOPSDKConfig.json沙盒文件路径，不采集任何隐私信息
- (void)setupWithConfigFilePath:(NSString *)configFilePath;

/// SDK启动接口
/// @param completion SDK启动结果回调
/// @discussion 调用该接口前必须先调用初始化接口，将使用配置接口传入的配置文件启动SDK基础功能，需在用户同意隐私协议后调用；需要该接口回调返回成功才能保证其他功能的正常使用
- (void)startOSDKWithCompletion:(void(^)(NSError * _Nullable err))completion;

/// SDK带启动参数启动接口
/// @param config SDK启动配置，可传空
/// @param completion SDK启动结果回调
/// @discussion 调用该接口前必须先调用初始化接口，将使用配置接口传入的配置文件启动SDK基础功能，需在用户同意隐私协议后调用；需要该接口回调返回成功才能保证其他功能的正常使用
- (void)startOSDKWithConfig:(UOPStartConfig * _Nullable)config completion:(void(^)(NSError * _Nullable err))completion;

/// SDK是否已启动
/// @discussion SDK初始化与启动两步操作均完成且成功返回YES，否则返回NO。
- (BOOL)isStarted;

/// 是否已完成SDK初始化
/// @discussion SDK初始化与启动两步操作均完成且成功返回YES，否则返回NO。
- (BOOL)isInited API_DEPRECATED("use isStarted instead.", ios(8.0, 10.0));

/// sdk 版本号
@property (nonatomic, copy, readonly) NSString *sdkVersion;
/// sdk 名称
@property (nonatomic, copy, readonly) NSString *sdkName;

/// sdk启动配置
@property (nonatomic, strong, readonly) UOPStartConfig *startConfig;

- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;

#pragma mark - DEPRECATED
/// 禁止使用，即将移除
- (void)startConfig:(UOPConfigManager *)config
      launchOptions:(NSDictionary *)launchOptions
           complete:(void (^)(NSError * _Nullable err))complete API_DEPRECATED("This method will be deprecated soon, use -setupWithConfigFilePath:completion: instead.", ios(8.0, 10.0));

/// SDK旧初始化接口
/// @param configFilePath 配置文件沙盒路径
/// @param completion 初始化完成回调
/// @discussion 读取 mainBundle 中的 UOPSDKConfig.json 文件
- (void)setupWithConfigFilePath:(NSString *)configFilePath
                     completion:(void(^)(NSError * _Nullable err))completion API_DEPRECATED("use -setupWithConfigFilePath: and -startOSDKWithCompletion: instead.", ios(8.0, 10.0));

@end

NS_ASSUME_NONNULL_END
