//
//  UPushOC.h
//  ComboSDK
//
//  Created by Zhang Gang on 2024/5/7.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIApplication.h>
#import <UserNotifications/UserNotifications.h>

NS_ASSUME_NONNULL_BEGIN

@interface UPushOC : NSObject <UNUserNotificationCenterDelegate>


+ (void)initWithAppKey:(NSString *)appKey
                channel:(NSString *)channel
     clearBadgeDisabled:(BOOL)clearBadgeDisabled
           alertEnabled:(BOOL)alertEnabled
          launchOptions:(NSDictionary *)launchOptions
               complete:(void (^)(BOOL granted, NSError * _Nullable err))complete;

//绑定别名
+ (void)addAlias:(NSString* __nonnull)name 
            type:(NSString* __nonnull)type
        response:(nullable void(^)(id __nonnull responseObject,NSError*__nonnull error))handle;

//添加标签
+(void)addTags:(__nonnull id)tag 
      response:(nullable void(^)(id __nonnull responseObject ,NSInteger remain,NSError*__nonnull error))handle;

@end

NS_ASSUME_NONNULL_END



